	subroutine vexpar(n,nextra,k,phi1,ip,phi2,iq,theta,ir,dgammacf,rho
     +	,x)
c***********************************************************************
c
c   FORTRAN subroutine to generate observations from a vector 
c   exponential autoregressive model.
c
c   Input: n = an integer containing the number of observations to
c              generate.
c          nextra = an integer containing the number of extra 
c                   observations.
c          k = an integer containing the number of componenets in the
c              vector time series.
c          phi1 = a double precision array of dimension ip x k x k
c                 containing the coefficients for the autoregressive
c                 part of the model.
c          ip = an integer containing the order of the autoregressive
c               part of the model.
c          phi2 = a double precision array of dimension iq x k x k
c                 containing the coefficients for the multiplicative
c                 part of the model.
c          iq = an integer containing the order of the multiplicative
c               part of the model.
c          theta = a double precision array of dimension ir x k x k
c                  containing the coefficients for the exponent term
c                  of the model.
c          ir = an integer containing the order of the exponent term
c               of the model.
c          dgammacf = a double precision scalar containing the coefficient
c                     in the exponent part of the model.
c          rho = a double precision scalar containing the error cross-
c                correlation.
c
c   Output: x = a double precision matrix of dimension n x k containing
c               the desired realization.c
c
c   Subprograms: vwn ((IMSL) DCHFAC, (IMSL) DRNMVN)
c
c   Written: 3/3/99 JLH
c
c***********************************************************************
c
	parameter (maxn = 1200, maxk = 5, maxp = 10, maxq = 10, maxr = 10)
	parameter (maxlag = 10, maxwk = 71950, in = 30)
c
	implicit double precision (a-h,p-z)
c
	integer n, nextra, k, ip, iq, ir
	double precision dgammacf, rho, cc
	double precision phi1(maxp,maxk,maxk), phi2(maxq,maxk,maxk)
	double precision theta(maxr,maxk,maxk), x(maxn,maxk)
	double precision eps(maxn,maxk), sigma(maxk, maxk)
	double precision ar(maxn,maxk), emult(maxn,maxk), eexp(maxn,maxk)
c
c  Generate noise:
c
	call vwn(n+nextra,maxn,k,maxk,rho,sigma,eps)
c	
	cc = -dgammacf
c
c   Generate realization:
c
	do iobs = 1,n+nextra
		do its = 1,k
			x(iobs,its) = eps(iobs,its)
			eexp(iobs,its) = x(iobs,its)
			emult(iobs,its) = x(iobs,its)
			ar(iobs,its) = x(iobs,its)
		enddo
c
c   Generate realization: 
c
c      First the linear terms:
c
		do j = 1,min(iobs-1,ip)
			do its = 1,k
			do its2 = 1,k
				ar(iobs,its) = ar(iobs,its) + phi1(j,its,its2)* 
     +				x(iobs-j,its2)
			enddo
			enddo
		enddo
c
c      Now the exponent:
c
		do j = 1,min(iobs-1,ir)
			do its = 1,k
				do its2 = 1,k
					eexp(iobs,its) = eexp(iobs,its) + 
     +					theta(j,its,its2)*x(iobs-j,its2)**2
				enddo
			enddo
		enddo		
c
c      Now the multiplicative term:
c
		do j = 1, min(iobs-1,iq)
			do its = 1,k
			do its2 = 1,k
				emult(iobs,its) = emult(iobs,its) + phi2(j,its,its2)*
     +				x(iobs-j,its2)
			enddo
			enddo
		enddo
		do its = 1,k
			x(iobs,its) = ar(iobs,its) + dexp(cc*eexp(iobs,its))*
     +			emult(iobs,its)
		enddo
	enddo
c
c   Return only the last n values of x(i,j)
c
	do iobs = 1,n
	do its = 1,k
		x(iobs,its) = x(iobs+nextra,its)
	enddo
	enddo
c
	return
	end
